<?php
// Hata ayıklama modunu aç
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Basit login kontrolü
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

// Sayfa yüklendiğinde uploads klasörünü ve session'ı temizle
$uploadDir = __DIR__ . '/uploads/';
if (is_dir($uploadDir)) {
    $files = glob($uploadDir . '*');
    foreach ($files as $file) {
        if (is_file($file)) {
            unlink($file);
        }
    }
}

// Eski karşılaştırma sonuçlarını temizle
unset($_SESSION['comparison_result']);

// Çıkış işlemi
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: login.php');
    exit;
}

$message = '';
$message_type = '';
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Excel Karşılaştırma Aracı</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="icon" href="data:image/svg+xml,<svg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 100 100%22><text y=%22.9em%22 font-size=%2290%22>📊</text></svg>">
</head>
<body>
    <div class="container">
        <header>
            <div class="header-left">
                <img src="assets/images/logo.png" alt="Logo" class="header-logo">
                <h1>Excel Karşılaştırma Aracı</h1>
            </div>
            <div class="user-info">
                Hoş geldiniz, <?php echo htmlspecialchars($_SESSION['username']); ?>!
                <a href="?logout=1" class="logout-btn">Çıkış</a>
            </div>
        </header>
        
        <main>
            <?php if ($message): ?>
                <div class="message <?php echo $message_type; ?>">
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>
            
            <div class="upload-section">
                <h2>Excel Dosyalarını Yükleyin</h2>
                <p>Banka Excel dosyası (E sütunu: Hesap Adı, K sütunu: Tutar) ve ML Excel dosyası (O sütunu: Hesap Adı, J sütunu: Tutar) yükleyerek karşılaştırma yapabilirsiniz.</p>
                
                <form id="uploadForm" enctype="multipart/form-data" class="upload-form">
                    <div class="file-group">
                        <label for="bank_file">Banka Excel Dosyası:</label>
                        <input type="file" id="bank_file" name="bank_file" accept=".xlsx,.xls" required>
                        <small>Desteklenen formatlar: .xlsx, .xls (Maksimum 10MB)</small>
                        <div class="file-status" id="bank_file_status"></div>
                    </div>
                    
                    <div class="file-group">
                        <label for="stock_file">ML Excel Dosyası:</label>
                        <input type="file" id="stock_file" name="stock_file" accept=".xlsx,.xls" required>
                        <small>Desteklenen formatlar: .xlsx, .xls (Maksimum 10MB)</small>
                        <div class="file-status" id="stock_file_status"></div>
                    </div>
                    
                    <div class="progress-container" id="progressContainer" style="display: none;">
                        <div class="progress-bar">
                            <div class="progress-fill" id="progressFill"></div>
                        </div>
                        <div class="progress-text" id="progressText">İşleniyor...</div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary" id="submitBtn">Dosyaları Karşılaştır</button>
                </form>
            </div>
            
            <?php if (isset($_SESSION['comparison_result']) && $_SESSION['comparison_result']['success']): ?>
                <div class="results-section">
                    <h2>Karşılaştırma Sonuçları</h2>
                    <div class="result-actions">
                        <button onclick="exportToExcel()" class="btn btn-secondary">Excel'e Aktar</button>
                        <button onclick="printResults()" class="btn btn-secondary">Yazdır</button>
                    </div>
                    <div id="results-table">
                        <?php include 'php/results_table.php'; ?>
                    </div>
                </div>
            <?php endif; ?>
        </main>
    </div>
    
    <!-- XLSX kütüphanesi -->
    <script src="https://unpkg.com/xlsx@0.18.5/dist/xlsx.full.min.js"></script>
    <script src="assets/js/script.js?<?php echo time() ?>"></script>
</body>
</html>
