<?php
// AJAX API Endpoint - Excel Dosya İşleme
ini_set('memory_limit', '512M'); // Bellek limitini artır
header('Content-Type: application/json; charset=utf-8');
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');

// Sadece POST isteklerini kabul et
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Sadece POST istekleri kabul edilir.']);
    exit;
}

try {
    // Session başlat
    session_start();
    
    // Giriş kontrolü
    if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
        http_response_code(401);
        echo json_encode(['success' => false, 'error' => 'Oturum süresi dolmuş. Lütfen tekrar giriş yapın.']);
        exit;
    }
    
    // Dosya kontrolü
    if (!isset($_FILES['bank_file']) || !isset($_FILES['stock_file'])) {
        echo json_encode(['success' => false, 'error' => 'Her iki dosya da gerekli.']);
        exit;
    }
    
    // Excel işleme
    require_once __DIR__ . '/ExcelProcessor.php';
    
    $processor = new ExcelProcessor();
    $result = $processor->processFiles($_FILES['bank_file'], $_FILES['stock_file']);
    
    if ($result['success']) {
        // Sonuçları session'da sakla
        $_SESSION['comparison_result'] = $result;
        
        echo json_encode([
            'success' => true,
            'message' => $result['message'],
            'data' => [
                'bank_count' => $result['bank_count'],
                'stock_count' => $result['stock_count']
            ]
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'error' => $result['error']
        ]);
    }
    
} catch (Exception $e) {
    error_log('Excel Processing Error: ' . $e->getMessage());
    
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Sunucu hatası oluştu. Lütfen tekrar deneyin.'
    ]);
}
